/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.recursive;

import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.common.recursive.CachedRecursiveSearch;
import org.simantics.db.exception.DatabaseException;

public abstract class FindRoots
extends CachedRecursiveSearch<Set<Resource>> {
    protected abstract boolean isRoot(Resource var1) throws DatabaseException;

    @Override
    protected Set<Resource> getSourceValue(Resource resource) throws DatabaseException {
        if (this.isRoot(resource)) {
            return Collections.singleton(resource);
        }
        return null;
    }

    private static int sharedElements(Set<Resource> a, Set<Resource> b) {
        int count = 0;
        for (Resource r : a) {
            if (!b.contains(r)) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected Set<Resource> combineNotNull(Set<Resource> a, Set<Resource> b) throws DatabaseException {
        int shared;
        int bSize;
        int aSize = a.size();
        if (aSize <= (bSize = b.size())) {
            shared = FindRoots.sharedElements(a, b);
            if (aSize == shared) {
                return b;
            }
        } else {
            shared = FindRoots.sharedElements(b, a);
            if (bSize == shared) {
                return a;
            }
        }
        THashSet combined = new THashSet(aSize + bSize - shared);
        combined.addAll(a);
        combined.addAll(b);
        return combined;
    }
}

