/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.guarded;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncProcedureSupport;
import org.simantics.db.procedure.AsyncMultiProcedure;

public abstract class GuardedAsyncMultiProcedure<T>
implements AsyncMultiProcedure<T>,
AsyncProcedureSupport {
    private final AsyncMultiProcedure<T> procedure;
    private final AtomicBoolean onceGuard = new AtomicBoolean(false);
    private final AtomicInteger resultCounter;

    public GuardedAsyncMultiProcedure(AsyncMultiProcedure<T> procedure) {
        this.procedure = procedure;
        this.resultCounter = new AtomicInteger(1);
    }

    @Override
    public final void exception(AsyncReadGraph graph, Throwable t) {
        this.except(graph, t);
    }

    protected void except(AsyncReadGraph graph, Throwable t) {
        if (this.onceGuard.compareAndSet(false, true)) {
            this.procedure.exception(graph, t);
        }
    }

    protected void offer(AsyncReadGraph graph, T item) {
        if (!this.onceGuard.get()) {
            this.procedure.execute(graph, item);
        }
    }

    protected void dec(AsyncReadGraph graph) {
        if (this.resultCounter.decrementAndGet() <= 0 && this.onceGuard.compareAndSet(false, true)) {
            this.procedure.finished(graph);
        }
    }

    protected void inc() {
        this.resultCounter.incrementAndGet();
    }

    public final void finished(AsyncReadGraph graph) {
        this.dec(graph);
    }
}

