/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.changeset;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.simantics.db.ChangeSet;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.utils.ReflectionUtils;
import org.slf4j.LoggerFactory;

public abstract class GenericChangeListener<Request, Result>
implements ChangeListener {
    private final Constructor<Read<Result>> constructor;

    public GenericChangeListener() {
        try {
            Class clazz = ReflectionUtils.getSingleParameterTypeExtending(this.getClass());
            this.constructor = clazz.getConstructor(ChangeSet.class);
            return;
        }
        catch (NoSuchMethodException | SecurityException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not get constructor with param {}", (Object)ChangeSet.class.getSimpleName(), (Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    public final void graphChanged(ChangeEvent e) throws DatabaseException {
        try {
            if (!this.preEventRequest()) {
                return;
            }
            Object event = e.getGraph().syncRequest(this.constructor.newInstance(e.getChanges()), TransientCacheListener.instance());
            this.onEvent(e.getGraph(), e.getMetadataI(), event);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            LoggerFactory.getLogger(this.getClass()).error("Could not construct new instance with {}", (Object)e.getChanges(), (Object)ex);
            throw new DatabaseException((Throwable)ex);
        }
    }

    public boolean preEventRequest() {
        return true;
    }

    public abstract void onEvent(ReadGraph var1, MetadataI var2, Result var3) throws DatabaseException;
}

