/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;

public class TransferableGraphRequests {
    private TransferableGraph1 tg;
    private ReadGraph graph;

    public TransferableGraphRequests(TransferableGraph1 tg, ReadGraph graph) {
        this.tg = tg;
        this.graph = graph;
    }

    public Resource getExternal(int id) throws DatabaseException {
        String uri = TransferableGraphUtils.getURI((TransferableGraph1)this.tg, (int)id);
        return this.graph.getPossibleResource(uri);
    }

    public Set<Integer> getObjects(int subject, Resource relation) throws DatabaseException {
        HashSet<Integer> result = new HashSet<Integer>();
        int i = 0;
        while (i < this.tg.statements.length) {
            Resource predicate;
            if (this.tg.statements[i] == subject && (predicate = this.getExternal(this.tg.statements[i + 1])) != null && this.graph.isSubrelationOf(predicate, relation)) {
                result.add(this.tg.statements[i + 3]);
            }
            i += 4;
        }
        return result;
    }

    public Set<Integer> getSubjects(int object, Resource inverseRelation) throws DatabaseException {
        HashSet<Integer> result = new HashSet<Integer>();
        int i = 0;
        while (i < this.tg.statements.length) {
            Resource predicate;
            if (this.tg.statements[i + 3] == object && (predicate = this.getExternal(this.tg.statements[i + 2])) != null && this.graph.isSubrelationOf(predicate, inverseRelation)) {
                result.add(this.tg.statements[i]);
            }
            i += 4;
        }
        return result;
    }

    public int getPossibleObject(int subject, Resource relation) throws DatabaseException {
        Set<Integer> objects = this.getObjects(subject, relation);
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        return -1;
    }

    public int getSingleObject(int subject, Resource relation) throws DatabaseException {
        Set<Integer> objects = this.getObjects(subject, relation);
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        if (objects.size() == 0) {
            throw new DatabaseException("No objects for subject " + subject + " and relation " + this.graph.getURI(relation));
        }
        throw new DatabaseException("Multiple (" + objects.size() + ") objects for subject " + subject + " and relation " + this.graph.getURI(relation));
    }

    public int getPossibleSubject(int object, Resource inverseRelation) throws DatabaseException {
        Set<Integer> subjects = this.getSubjects(object, inverseRelation);
        if (subjects.size() == 1) {
            return subjects.iterator().next();
        }
        return -1;
    }

    public int getSingleSubject(int object, Resource inverseRelation) throws DatabaseException {
        Set<Integer> subjects = this.getObjects(object, inverseRelation);
        if (subjects.size() == 1) {
            return subjects.iterator().next();
        }
        if (subjects.size() == 0) {
            throw new DatabaseException("No subjects for object " + object + " and relation " + this.graph.getURI(inverseRelation));
        }
        throw new DatabaseException("Multiple (" + subjects.size() + ") subjects for object " + object + " and relation " + this.graph.getURI(inverseRelation));
    }

    public <T> T getRelatedValue(int subject, Resource relation, Binding binding) throws DatabaseException {
        int object = this.getSingleObject(subject, relation);
        return this.getValue(object, binding);
    }

    public <T> T getPossibleRelatedValue(int subject, Resource relation, Binding binding) throws DatabaseException {
        int object = this.getPossibleObject(subject, relation);
        if (object == -1) {
            return null;
        }
        return this.getPossibleValue(object, binding);
    }

    public <T> T getValue(int subject, Binding binding) throws DatabaseException {
        Value value = TransferableGraphUtils.findValue((TransferableGraph1)this.tg, (int)subject);
        if (value == null) {
            throw new DatabaseException("No value for subject " + subject);
        }
        try {
            return (T)value.value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getPossibleValue(int subject, Binding binding) {
        Value value = TransferableGraphUtils.findValue((TransferableGraph1)this.tg, (int)subject);
        if (value == null) {
            return null;
        }
        try {
            return (T)value.value.getValue(binding);
        }
        catch (AdaptException adaptException) {
            return null;
        }
    }

    public boolean isInstanceOf(int subject, Resource type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        for (int t : this.getObjects(subject, L0.InstanceOf)) {
            Resource tr = this.getExternal(t);
            if (tr == null || !this.graph.isInheritedFrom(tr, type)) continue;
            return true;
        }
        return false;
    }

    public String formatResource(int r) throws DatabaseException {
        Value value;
        Object result = "" + r;
        String uri = TransferableGraphUtils.getURI((TransferableGraph1)this.tg, (int)r);
        if (!uri.isEmpty()) {
            result = uri;
        }
        if ((value = TransferableGraphUtils.findValue((TransferableGraph1)this.tg, (int)r)) != null) {
            result = (String)result + " (value " + String.valueOf(value.value) + ")";
        }
        return result;
    }

    public String listStatements() throws DatabaseException {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.tg.statements.length) {
            int subject = this.tg.statements[i];
            int predicate = this.tg.statements[i + 1];
            int object = this.tg.statements[i + 3];
            b.append(this.formatResource(subject) + " " + this.formatResource(predicate) + " " + this.formatResource(object) + "\n");
            i += 4;
        }
        return b.toString();
    }

    public ReadGraph getGraph() {
        return this.graph;
    }
}

