/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.lang.reflect.Method;
import java.util.Map;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.ServiceException;

public class MetadataUtils {
    private static final boolean TRACE_METADATA_SERIALIZATION = false;

    public static <T extends Metadata> boolean hasMetadata(Map<String, byte[]> metadata, Class<T> clazz) {
        return metadata.containsKey(clazz.getName());
    }

    public static <T extends Metadata> T getMetadata(Session session, Map<String, byte[]> metadata, Class<T> clazz) throws ServiceException {
        byte[] data = metadata.get(clazz.getName());
        try {
            Method m = clazz.getMethod("deserialise", Session.class, byte[].class);
            return (T)((Metadata)m.invoke(null, session, data));
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.defaultLogError(e.toString());
            return null;
        }
    }

    public static <T> void addMetadata(Session session, Map<String, byte[]> metadata, Metadata data) throws ServiceException {
        byte[] blob = data.serialise(session);
        metadata.put(data.getClass().getName(), blob);
    }
}

