/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.Serializers;

public abstract class ACommentMetadata
implements Metadata {
    final boolean DEBUG = true;
    protected ArrayList<String> comments = new ArrayList();

    public ACommentMetadata(TreeMap<String, byte[]> metadata) {
        if (metadata != null) {
            byte[] data = metadata.get(ACommentMetadata.class.getName());
            this.initialize(data);
        }
    }

    public ACommentMetadata(byte[] data) {
        this.initialize(data);
    }

    private void initialize(byte[] data) {
        if (data != null) {
            try {
                String[] strings;
                String[] stringArray = strings = Serializers.deserializeStrings(data);
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.comments.add(s);
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.defaultLogError(e);
            }
        }
    }

    public ACommentMetadata add(String string) {
        this.comments.add(string);
        return this;
    }

    public int size() {
        return this.comments.size();
    }

    public ACommentMetadata add(ACommentMetadata cm) {
        if (cm == null) {
            return this;
        }
        this.comments.addAll(cm.comments);
        return this;
    }

    public String toString() {
        Object t = "";
        int size = this.comments.size();
        Iterator<String> it = this.comments.iterator();
        int i = 0;
        while (i < size) {
            t = (String)t + it.next() + "\n";
            ++i;
        }
        return t;
    }

    public byte[] serialise(Session session) {
        try {
            return Serializers.serializeStrings(this.comments.toArray(new String[this.comments.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.defaultLogError(e.toString());
            return new byte[0];
        }
    }
}

