/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.uri;

import java.util.Arrays;
import java.util.Map;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

/**
 * TODO: should this be considered deprecated and favor {@link Queries#resource(String)} ?
 */
public class URIToResource implements AsyncRead<Resource> {
	String[] nameSequence;
	
	public URIToResource(String[] nameSequence) {
		this.nameSequence = nameSequence;
	}
	
	public URIToResource(String uri) {
		this.nameSequence = URIEscape.splitURI(uri);
	}

	@Override
	public void perform(AsyncReadGraph g, final AsyncProcedure<Resource> procedure) {
		if(nameSequence.length == 0)
			procedure.execute(g, g.getRootLibrary());
		else
			g.asyncRequest(new URIToResource(Arrays.copyOf(nameSequence, nameSequence.length-1)),
				new AsyncProcedure<Resource>() {

					@Override
					public void execute(AsyncReadGraph g, Resource result) {
						g.asyncRequest(new EscapedChildMapOfResource(result),
							new AsyncProcedure<Map<String, Resource>>() {

								@Override
								public void execute(AsyncReadGraph g, Map<String, Resource> map) {
									Resource r = map.get(nameSequence[nameSequence.length-1]);
									if(r != null)
										procedure.execute(g, r);
									else
										procedure.exception(g, new ResourceNotFoundException(
												URIEscape.joinURI(nameSequence)));
								}
							
								@Override
								public void exception(AsyncReadGraph g, Throwable t) {
									procedure.exception(g, t);															
								}
							
							}
						);
					}
				
					@Override
					public void exception(AsyncReadGraph g, Throwable t) {
						procedure.exception(g, t);						
					}
				
				}
			);
		
	}
	
	@Override
	public int hashCode() {
		return Arrays.hashCode(nameSequence);
	}

    @Override
    public int threadHash() {
    	return hashCode();
    }

	@Override
	public boolean equals(Object obj) {
		if(this == obj)
			return true;
		if(!(obj instanceof URIToResource))
			return false;
		return Arrays.equals(nameSequence, ((URIToResource)obj).nameSequence);
	}
    
    @Override
    public int getFlags() {
        return 0;
    }

}
