package org.simantics.db.common.procedure.single;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;

final public class SyncReadProcedure<T> implements AsyncProcedure<T> {

	private Throwable exception = null;
	public T result = null;
	
	@Override
	public synchronized void execute(AsyncReadGraph graph, T t) {
		result = t;
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable t) {
		exception = t;
	}
	
	public void checkAndThrow() throws DatabaseException {
		if(exception != null) {
			if (exception instanceof DatabaseException)
				throw (DatabaseException) exception;
			else
				throw new DatabaseException(
						"Unexpected exception in ReadGraph.syncRequest(AsyncRead)",
						exception);
		}
	}
	
}

