package org.simantics.db.common.utils;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.common.NamedResource;
import org.simantics.utils.strings.AlphanumComparator;

public class VersionInfo {

	public String baseName;
	public String version;
	public Collection<NamedResource> versions;

	public VersionInfo(String baseName, String version, Collection<NamedResource> versions) {
		this.baseName = baseName;
		this.version = version;
		this.versions = versions;
	}
	
	public boolean containsVersion(String version) {
		for(NamedResource r : versions) if(r.getName().equals(version)) return true;
		return false;
	}
	
	public Collection<NamedResource> getOlderVersions() {
		ArrayList<NamedResource> result = new ArrayList<NamedResource>();
		for(NamedResource r : versions) {
			if(AlphanumComparator.COMPARATOR.compare(r.getName(), version) < 0) result.add(r);
		}
		return result;
	}
	
	public Collection<NamedResource> getNewerVersions() {
		ArrayList<NamedResource> result = new ArrayList<NamedResource>();
		for(NamedResource r : versions) {
			if(AlphanumComparator.COMPARATOR.compare(r.getName(), version) > 0) result.add(r);
		}
		return result;
	}

	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof VersionInfo))
            return false;
        VersionInfo r = (VersionInfo)object;
        return r.baseName.equals(baseName) && r.version.equals(version) && r.versions.equals(versions);
	}
	
	@Override
	public int hashCode() {
		return baseName.hashCode() + 31*version.hashCode() + 41*versions.hashCode();
	}
	
	
}
