/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.uri;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * Tries to retrieve URIs for specified resources. Returns <code>null</code> if
 * URI is undefined. This query follows the semantics of
 * {@link ReadGraph#getPossibleURI(Resource)}.
 * 
 * @author Antti Villberg
 */
public class ResourceToPossibleURI extends ResourceRead<String> {

    public ResourceToPossibleURI(Resource resource) {
        super(resource);
    }

    @Override
    public String perform(ReadGraph g) throws DatabaseException {
    	if(g.getRootLibrary().equals(resource)) return "http:/";
    	Layer0 L0 = Layer0.getInstance(g);
    	String name = g.getPossibleRelatedValue(resource, L0.HasName, Bindings.STRING);
    	if(name == null) return null;
        String escapedName = URIStringUtils.escape((String) name);
        Resource parent = g.getPossibleObject(resource, L0.PartOf);
        if(parent == null) return null;
        String parentURI = g.syncRequest(new ResourceToPossibleURI(parent));
        if(parentURI == null) return null;
        return parentURI + "/" + escapedName;
    }

}
