/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.transientgraph;

import gnu.trove.list.array.TIntArrayList;

import org.simantics.db.VirtualGraphContext;

public class StatementBuilder {
	
	TIntArrayList data = new TIntArrayList();
	
	public StatementBuilder(int ... stms) {
		data.add(stms);
	}

	public void add(int ... stms) {
		data.add(stms);
	}
	
	public void commit(VirtualGraphContext context, int resource) {
		context.updateStatements(resource, data.toArray());
	}

	public static void commit(VirtualGraphContext context, int resource, int ... stms) {
		context.updateStatements(resource, stms);
	}
	
}
