/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.Operation;
import org.simantics.db.RequestProcessor;
import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.UndoTraits;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;


/**
 * TODO: fix this javadoc to document the correct class!!
 * 
 * Usage samples:
 * 
 * <p>
 * Synchronous read without checked exceptions:
 * </p>
 * <pre>
 * Resource r = new SimpleReadGraphRequest&lt;Resource&gt;(session) {
 *     {@code @Override}
 *     public Resource run(Graph g) {
 *         Resource r = doSomethingThatMayFail();
 *         return r;
 *     }
 * }.sync();
 * </pre>
 * 
 * <p>
 * Synchronous read with a selected checked exception that may be thrown:
 * </p>
 * <pre>
 * Resource r = new SimpleReadGraphRequest&lt;Resource&gt;(session) {
 *     {@code @Override}
 *     public Resource run(Graph g) throws CheckedException {
 *         Resource r = doSomethingThatMayFailWithCheckedException();
 *         return r;
 *     }
 * }.sync(CheckedException.class);
 * </pre>
 * 
 * <p>
 * Asynchronous read with a completed() method for examining the result:
 * </p>
 * <pre>
 * Resource r = new SimpleReadGraphRequest&lt;Resource&gt;(session) {
 *     {@code @Override}
 *     public Resource run(Graph g) {
 *         Resource r = doSomethingThatMayFail();
 *         return r;
 *     }
 *     public void completed(Resource result) {
 *         // quickly dispatch the result somewhere, do nothing serious in this code.
 *     }
 * }.async();
 * </pre>
 * 
 * @param <T> the result type
 */
public abstract class WriteRequest implements Write, UndoTraits, WriteInterface<Object> {

    private final VirtualGraph provider;
    
    public WriteRequest() {
        this.provider = null;
    }

    public WriteRequest(VirtualGraph provider) {
        this.provider = provider;
    }

    @Override
    public void commitOk(Operation op) {
    }

    @Override
    final public VirtualGraph getProvider() {
        return provider;
    }

    @Override
    public void request(AsyncRequestProcessor processor, final Procedure<Object> procedure) {
    	processor.asyncRequest(this, parameter -> {
    		if(parameter != null) procedure.exception(parameter);
    		else procedure.execute(null);
		});
    }
    
    @Override
    public Object request(RequestProcessor processor) throws DatabaseException {
    	processor.syncRequest(this);
    	return null;
    }

}
