/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSet;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class TypeString extends BinaryRead<ResourceSet, String, String> {

	final private Layer0 L0;

	public TypeString(Layer0 L0, Set<Resource> set) {
		super((ResourceSet)set, " ");
		this.L0 = L0;
	}

	@Override
	public String perform(ReadGraph graph) throws DatabaseException {

		if (parameter == null || parameter.isEmpty())
			return "";

		StringBuilder result = new StringBuilder();

		boolean first = true;
		int size = parameter.size();
		for(int i=0;i<size;i++) {
			Resource r = parameter.get(i);
			String name = graph.getPossibleRelatedValue(r, L0.HasName, Bindings.STRING);
			if (name != null) {
				if(!first) result.append(parameter2);
				else first = false;
				result.append(escapeToken(name));
			}
		}

		return result.toString();

	}

	public static String escapeToken(String token) {
		return token.replaceAll("( |\\\\)", "\\\\$0");
	}

}