/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;

final public class StatementsWithRange extends ResourceRead3<Set<Statement>> {

    public StatementsWithRange(Resource subject, Resource subrelationOf, Resource inherits) {
        super(subject, subrelationOf, inherits);
    }

    @Override
    public Set<Statement> perform(ReadGraph graph) throws DatabaseException {
        
    	Set<Statement> result = new HashSet<Statement>();
    	for(Statement stm : graph.getStatements(resource, resource2)) {
    		if(graph.isInheritedFrom(stm.getObject(), resource3)) result.add(stm);
    	}
    	return result;
        
    }

}
