/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

import gnu.trove.set.hash.THashSet;

/**
 * @author Tuukka Lehtonen
 * @since 1.41.0, 1.35.2
 */
public class ResourceSetURIs extends UnaryRead<Set<Resource>, Set<String>> {

    public ResourceSetURIs(Set<Resource> set) {
        super(set);
    }

    @Override
    public Set<String> perform(ReadGraph graph) throws DatabaseException {
        if (parameter == null || parameter.isEmpty())
            return Collections.emptySet();

        Set<String> result = new THashSet<String>(parameter.size());
        for (Resource r : parameter) {
            String uri = graph.getPossibleURI(r);
            if (uri != null)
                result.add(uri);
        }

        return result;
    }

}