/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.procedure.AsyncProcedure;

final public class PossibleTag extends ResourceAsyncRead2<Resource> {

    public PossibleTag(Resource resource, Resource predicate) {
        super(resource, predicate);
    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<Resource> procedure) {
        
        graph.forPossibleStatement(resource, resource2, new AsyncProcedure<Statement>() {

			@Override
			public void execute(AsyncReadGraph graph, Statement result) {
			    if(result == null)
			        procedure.execute(graph, null);
			    else 
                    procedure.execute(graph, result.getPredicate());
			        
			}

			@Override
			public void exception(AsyncReadGraph graph, Throwable t) {
				procedure.exception(graph, t);
			}
        	
        });
        
    }

}
