/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

final public class PossibleObjectWithName extends TernaryRead<Resource, Resource, String, Resource> {

    public PossibleObjectWithName(Resource resource, Resource predicate, String name) {
        super(resource, predicate, name);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(graph);
        Resource result = null;
        for(Resource object : graph.getObjects(parameter, parameter2)) {
        	String name = graph.getPossibleRelatedValue(object, b.HasName);
            if(parameter3.equals(name)) {
                if(result != null) return null;
                result = object;
            }
        }
        return result;
    }

}
