package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class PossibleNearestOwner extends ResourceRead2<Resource> {

    public PossibleNearestOwner(Resource resource, Resource type) {
        super(resource, type);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
    	Resource owner = graph.syncRequest(new PossibleOwner(resource));
    	if(owner == null) return null;
    	if(graph.isInstanceOf(owner, resource2)) return owner;
    	return graph.syncRequest(new PossibleNearestOwner(owner, resource2));
    }
    
}