/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Antti Villberg
 */
public class IsParent extends ResourceRead2<Boolean> {

    public IsParent(Resource possibleParent, Resource possibleChild) {
        super(possibleParent, possibleChild);
    }

    @Override
    public Boolean perform(ReadGraph graph) throws DatabaseException {
    	
    	if(resource.equals(resource2)) return true;
    	
    	Layer0 L0 = Layer0.getInstance(graph);
    	Resource parent = graph.getPossibleObject(resource2, L0.PartOf);
    	if(parent == null) return false;
    	
    	return graph.sync(new IsParent(resource, parent));
    	
    }

}
