/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;

public abstract class GenericReadBase2<R> implements Read<R>, ReadInterface<R> {

    @Override
    public void request(AsyncRequestProcessor processor, AsyncProcedure<R> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Procedure<R> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncProcedure<R> procedure) {
    	processor.asyncRequest(this, procedure);
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncListener<R> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Listener<R> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncListener<R> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public R request(RequestProcessor processor) throws DatabaseException {
    	return processor.syncRequest(this);
    }
    
}
