/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class EnumerationMap extends ResourceRead<Map<String, Resource>> {

	public EnumerationMap(Resource type) {
		super(type);
	}

	@Override
	public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		Map<String, Resource> result = new HashMap<String, Resource>();
		for(Resource lit : graph.syncRequest(new ObjectsWithType(resource, L0.ConsistsOf, resource))) {
			String label = graph.getPossibleRelatedValue(lit, L0.HasLabel);
			if(label == null) label = graph.getRelatedValue(lit, L0.HasName);
			result.put(label, lit);
		}
		return result;

	}

}
