/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.provider;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

/**
 * An interface for externalizing the logic of retrieving an arbitrary resource
 * for some purpose.
 * 
 * <p>
 * A {@link ReadGraph} is provided to allow implementations to browse the graph
 * in order to retrieve a resource.
 * </p>
 * 
 * <p>
 * This interface has an asynchronously operating counterpart, {@link AsyncResourceProvider}.
 * </p>
 * 
 * @see ResourceProviders
 * @see AsyncResourceProvider
 * 
 * @author Tuukka Lehtonen
 */
public interface ResourceProvider {

    /**
     * @param graph a graph for retrieving the resource to return
     * @return the provided resource
     */
    Resource get(ReadGraph graph);

}
