/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.MultiProcedure;

public class NoneToAsyncMultiProcedure<T> implements AsyncMultiProcedure<T> {

	final private MultiProcedure<T> procedure;

	public NoneToAsyncMultiProcedure(MultiProcedure<T> procedure) {
		this.procedure = procedure;
	}
	
	@Override
	public void execute(AsyncReadGraph graph, final T result) {
	    procedure.execute(result);
	}

	@Override
	public void finished(AsyncReadGraph graph) {
	    procedure.finished();
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable t) {
		procedure.exception(t);
	}
	
    @Override
    public String toString() {
        return "NoneToAsyncMultiProcedure -> " + procedure;
   }

}
