/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single.wrapper;

import java.util.concurrent.atomic.AtomicBoolean;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.procedure.AsyncProcedure;

final public class SingleFunctionalOrNullProcedure<Result> extends AsyncMultiProcedureAdapter<Result> {
    
	final String location;
	final AsyncProcedure<Result> procedure;
    final AtomicBoolean found = new AtomicBoolean(false);
    final AtomicBoolean guard = new AtomicBoolean(false);
    final AtomicBoolean exception = new AtomicBoolean(false);
    
    public SingleFunctionalOrNullProcedure(String location, AsyncProcedure<Result> procedure) {
        
    	this.location = location;
        this.procedure = procedure;
        
    }
    
    @Override
    public void execute(AsyncReadGraph graph, Result result) {
        
        assert(!guard.get());

        if(found.compareAndSet(false, true)) {
            procedure.execute(graph, result);
        } else {
            if(exception.compareAndSet(false, true)) {
                procedure.exception(graph, new ManyObjectsForFunctionalRelationException(location + " -> " + procedure));
            }
        }
        
    }
	
    @Override
    public void finished(AsyncReadGraph graph) {

        assert(!guard.get());
        
        guard.set(true);
        
        if(found.compareAndSet(false, true)) {
            procedure.execute(graph, null);
        }
        
    }
    
    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        
        procedure.exception(graph, t);
        
    }
    
    @Override
    public String toString() {
        return "SingleFunctionalOrNullProcedure -> " + procedure;
    }

}
