/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.adapter;

import org.simantics.db.Disposable;
import org.simantics.db.procedure.Listener;

abstract public class DisposableListener<T> implements Listener<T>, Disposable {

	private boolean isDisposed = false;

    @Override
    final public boolean isDisposed() {
        return isDisposed;
    }

	@Override
	public void dispose() {
		isDisposed = true;
	}

}
