/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncListener;
import org.slf4j.LoggerFactory;

public abstract class AsyncListenerAdapter<T> implements AsyncListener<T> {

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        LoggerFactory.getLogger(getClass()).error("Failed to listen", t);
    }

    @Override
    public void execute(AsyncReadGraph graph, T result) {
    }

    @Override
    public abstract boolean isDisposed();

}
