/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.procedure.AsyncProcedure;

final public class ResourceByURI extends UnaryAsyncRead<String, org.simantics.db.Resource> {

    public ResourceByURI(String URI) {
    	super(URI);
    	assert(URI != null);
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<org.simantics.db.Resource> procedure) {
        graph.forResource(parameter, procedure);
    }

    @Override
    public String toString() {
    	return "Resource[" + parameter + "]";
    }
    
}
