/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.ServiceException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public final class IsExternalEntity extends ResourceRead<Boolean> {

    public IsExternalEntity(Resource resource) {
        super(resource);
    }

    @Override
    public Boolean perform(ReadGraph graph) throws ServiceException {
        return graph.isInstanceOf(resource, Layer0.getInstance(graph).ExternalEntity);
    }

}
