/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.SetResourceRead2;
import org.simantics.db.procedure.SyncSetListener;

final public class ForObjectSet extends SetResourceRead2<Resource> {

    public ForObjectSet(Resource resource, Resource resource2, SyncSetListener<Resource> procedure) {
        super(resource, resource2, procedure);
    }

    @Override
    public void execute(AsyncReadGraph graph, final SyncSetListener<Resource> procedure) {
    	graph.forObjectSet(resource, resource2, procedure);
    }

}
