/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncMultiRead;
import org.simantics.db.procedure.AsyncMultiProcedure;

final public class ForEachPredicate extends ResourceAsyncMultiRead<Resource> {

    public ForEachPredicate(Resource resource) {
        super(resource);
    }

	@Override
	public void perform(AsyncReadGraph graph, AsyncMultiProcedure<Resource> procedure) {
    	graph.forEachPredicate(resource, procedure);
	}

}
