/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

final public class Builtin implements AsyncRead<Resource> {

    final protected String URI;
    
    @Override
    public int hashCode() {
        return URI.hashCode();
    }
    
    @Override
    public int threadHash() {
    	return hashCode();
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        Builtin r = (Builtin)object;
        return URI.equals(r.URI);
    }

    public Builtin(String URI) {
    	assert(URI != null);
        this.URI = URI;
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<Resource> procedure) {
        
        graph.forBuiltin(URI, procedure);
        
    }
    
    @Override
    public int getFlags() {
        return 0;
    }

}
