/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.auth;

import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.service.ServerInformation;

public class UserAuthenticationAgents {

    private static class Static implements UserAuthenticationAgent {
        
        private final UserAuthenticator auth;

        public Static(UserAuthenticator auth) {
            this.auth = auth;
        }

        @Override
        public UserAuthenticator getAuthenticator(ServerInformation information) {
            return auth;
        }
        
    }

    public static UserAuthenticationAgent staticAgent(UserAuthenticator auth) {
        return new Static(auth);
    }

}