/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.VirtualGraphContext;
import org.simantics.db.VirtualGraphSource;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.Pair;

public abstract class VirtualGraphObjectSource implements VirtualGraphSource {

    private BijectionMap<Object, Integer> hash = new BijectionMap<Object, Integer>();
    
    class ResourceObject {
        public int id;
        public ResourceObject(int id) {
            this.id = id;
        }
        @Override
        public int hashCode() {
            return id;
        }
        @Override
        public boolean equals(Object object) {
            if (this == object)
                return true;
            else if (object == null)
                return false;
            else if (ResourceObject.class != object.getClass())
                return false;
            ResourceObject r = (ResourceObject)object;
            return r.id == id;
        }
    }
    
//    protected void invalidate(VirtualGraphContext context, Object subject, Object predicate) {
//        context.invalidate(getOrCreate(context, subject), getOrCreate(context, predicate));
//    }

//    protected Object getObject(VirtualGraphContext context, org.simantics.db.Resource resource) {
//        int id = context.getIndex(resource);
//        Object result = new Resource(id);
//        hash.map(result, id);
//        return result;
//    }
    
//    private int getOrCreate(VirtualGraphContext context, Object object) {
//        if(object instanceof org.simantics.db.Resource) return context.getIndex((org.simantics.db.Resource)object);
//        Integer value = hash.getRight(object);
//        if(value == null) {
//            value = context.newResource();
//            hash.map(object, value);
//        }
//        return value;
//    }
    
    private Object existingOrResource(VirtualGraphContext context, int id) {
        Object value = hash.getLeft(id);
        if(value == null) return context.getResource(id);
        else return value;
    }

//    @Override
//    final public int[] getStatements(VirtualGraphContext context, int resource) {
//        Object[] stms = getStatements(existingOrResource(context, resource));
//        int[] result = new int[stms.length];
//        for(int i=0;i<stms.length;i++) result[i] = getOrCreate(context, stms[i]);
//        return result;
//    }
//
//    @Override
//    final public Pair<Object, Binding> getValue(VirtualGraphContext context, int resource) {
//        return getValue(context, existingOrResource(context, resource));
//    }
    
//    public org.simantics.db.Resource getResource(VirtualGraphContext context, Object virtual) {
//        return (org.simantics.db.Resource)context.getResource(getOrCreate(context, virtual));
//    }

    abstract public Object[] getStatements(Object resource);
    abstract public Pair<Object, Binding> getValue(VirtualGraphContext context, Object resource);
    
}
