package org.simantics.db.common;

import org.simantics.db.Session;
import org.simantics.db.service.LifecycleSupport;


public class SessionThreads {

	public static boolean isClosed() {
		Thread current = Thread.currentThread();
		if(current instanceof SessionThread) {
			Session session = ((SessionThread)current).getSession();
			LifecycleSupport ls = session.peekService(LifecycleSupport.class);
			if(ls != null) return ls.isClosed();
			else return true;
		} else {
			return false;
		}
	}
	
}
