package org.simantics.db.common;

import java.util.concurrent.atomic.AtomicInteger;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncProcedure;

final public class ProcedureBarrier<T> extends AtomicInteger {

	private static final long serialVersionUID = -2699547741948233067L;
	
	private volatile Throwable throwable;
	
	public ProcedureBarrier(int initial) {
		super(initial);
	}
	
	final synchronized public void except(Throwable throwable) {
		this.throwable = throwable;
	}
	
	final public Throwable getThrowable() {
		return throwable;
	}
	
	final public void dec(AsyncReadGraph graph, AsyncProcedure<T> procedure, Throwable throwable) {
		synchronized(this) {
			this.throwable = throwable;
		}
		if(decrementAndGet() == 0) {
			procedure.exception(graph, throwable);
		}
	}

	final public void dec(AsyncReadGraph graph, AsyncProcedure<T> procedure, T result) {
		if(decrementAndGet() == 0) {
			if(throwable != null) procedure.exception(graph, throwable);
			else procedure.execute(graph, result);
		}
	}
	
}
