package org.simantics.db.common;

import org.simantics.db.Resource;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class LifeCycleContext {

	final private Resource resource;
	final private Function1<LifeCycleContext,Tuple0> load;
	final private Function1<LifeCycleContext,Tuple0> unload;
	
	public LifeCycleContext(Resource resource, Function1<LifeCycleContext, Tuple0> load, Function1<LifeCycleContext, Tuple0> unload) {
		this.resource = resource;
		this.load = load;
		this.unload = unload;
	}
	
	public void load() {
		if(load != null) load.apply(this);
	}
	
	public void unload() {
		if(unload != null) unload.apply(this);
	}
	
}
