/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.databoard.util.binary.UTF8;

public class Blob
implements RandomAccessBinary {
    RandomAccessBinary parent;
    long start;
    long length;
    WeakHashMap<Blob, Object> children;
    long pointer = 0L;

    public Blob(RandomAccessBinary parent) throws IOException {
        this(parent, 0L, parent.length());
    }

    public Blob(RandomAccessBinary parent, long start, long length) {
        this.parent = parent;
        this.start = start;
        this.length = length;
    }

    public Blob createSubBlob(long start, long length) {
        Blob result = new Blob(this, start, length);
        if (this.children == null) {
            this.children = new WeakHashMap(1);
        }
        this.children.put(result, Blob.class);
        return result;
    }

    public RandomAccessBinary getParent() {
        return this.parent;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return this.parent.isOpen();
    }

    @Override
    public void insertBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        if (bytes == 0L) {
            return;
        }
        if (bytes < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.pointer < 0L) {
            throw new IndexOutOfBoundsException();
        }
        RandomAccessBinary backend = this.parent;
        long startInBackend = this.start;
        while (backend instanceof Blob) {
            startInBackend += ((Blob)backend).start;
            backend = ((Blob)backend).parent;
        }
        if (this.pointer > this.length) {
            bytes += this.pointer - this.length;
            this.pointer = this.length;
        }
        backend.position(startInBackend + this.pointer);
        backend.insertBytes(bytes, side);
        this.length += bytes;
        if (this.parent instanceof Blob) {
            ((Blob)this.parent).childGrewBackend(this, this.start + this.pointer, bytes);
        }
        if (this.children != null) {
            for (Blob child : this.children.keySet()) {
                child.parentGrew(this, this.pointer - child.start, bytes, side);
            }
        }
    }

    void childGrewBackend(Blob child, long pos, long bytes) {
        this.length += bytes;
        assert (bytes >= 0L);
        if (this.children != null) {
            for (Blob c : this.children.keySet()) {
                if (c == child || pos > c.start) continue;
                c.start += bytes;
            }
        }
        if (this.parent instanceof Blob) {
            ((Blob)this.parent).childGrewBackend(this, pos + this.start, bytes);
        }
    }

    void parentGrew(Blob parent, long pos, long bytes, RandomAccessBinary.ByteSide side) {
        if (pos < 0L || pos == 0L && side != RandomAccessBinary.ByteSide.Right) {
            this.start += bytes;
            return;
        }
        if (pos >= this.length) {
            return;
        }
        if (pos == 0L && side == RandomAccessBinary.ByteSide.Right || pos == this.length && side == RandomAccessBinary.ByteSide.Left || pos > 0L && pos < this.length) {
            this.length += bytes;
        }
        if (this.children != null) {
            for (Blob child : this.children.keySet()) {
                child.parentGrew(this, pos - child.start, bytes, side);
            }
        }
    }

    @Override
    public void removeBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        if (this.pointer < 0L || this.pointer + bytes > this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bytes == 0L) {
            return;
        }
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes must be positive value");
        }
        RandomAccessBinary backend = this.parent;
        long startInBackend = this.start;
        while (backend instanceof Blob) {
            startInBackend += ((Blob)backend).start;
            backend = ((Blob)backend).parent;
        }
        backend.position(startInBackend + this.pointer);
        backend.removeBytes(bytes, side);
        this.length -= bytes;
        if (this.parent instanceof Blob) {
            ((Blob)this.parent).childShrankBackend(this, this.start + this.pointer, bytes);
        }
        if (this.children != null) {
            for (Blob child : this.children.keySet()) {
                child.parentShrunk(this, this.pointer - child.start, bytes);
            }
        }
    }

    void childShrankBackend(Blob child, long pos, long bytes) {
        this.length -= bytes;
        assert (bytes >= 0L);
        if (this.children != null) {
            for (Blob c : this.children.keySet()) {
                if (c == child || pos >= c.start) continue;
                c.start -= bytes;
            }
        }
        if (this.parent instanceof Blob) {
            ((Blob)this.parent).childShrankBackend(this, pos + this.start, bytes);
        }
    }

    void parentShrunk(Blob parent, long pos, long bytes) {
        if (pos < 0L) {
            this.start -= bytes;
            return;
        }
        if (pos >= this.length) {
            return;
        }
        this.length -= bytes;
        if (this.children != null) {
            for (Blob child : this.children.keySet()) {
                child.parentShrunk(this, pos - child.start, bytes);
            }
        }
    }

    @Override
    public void setLength(long newLength) throws IOException {
        long oldLength = this.length;
        if (oldLength == newLength) {
            return;
        }
        if (oldLength < newLength) {
            long oldPointer = this.pointer;
            this.pointer = oldLength;
            this.insertBytes(newLength - oldLength, RandomAccessBinary.ByteSide.Left);
            this.pointer = oldPointer;
            return;
        }
        long oldPointer = this.pointer;
        this.pointer = newLength;
        this.removeBytes(oldLength - newLength, RandomAccessBinary.ByteSide.Left);
        this.pointer = oldPointer;
    }

    public RandomAccessBinary getSource() {
        return this.parent;
    }

    @Override
    public void flush() throws IOException {
        this.parent.flush();
    }

    @Override
    public void reset() throws IOException {
        this.parent.reset();
        this.length = this.parent.length();
    }

    @Override
    public void write(int b) throws IOException {
        this.assertHasWritableBytes(1L);
        this.parent.position(this.start + this.pointer);
        this.parent.write(b);
        ++this.pointer;
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.assertHasWritableBytes(1L);
        this.parent.position(this.start + this.pointer);
        this.parent.write(b);
        ++this.pointer;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.assertHasWritableBytes(1L);
        this.parent.position(this.start + this.pointer);
        this.parent.write((byte)(v ? 1 : 0));
        ++this.pointer;
    }

    @Override
    public void writeFully(ByteBuffer src) throws IOException {
        long bytes = src.remaining();
        this.assertHasWritableBytes(bytes);
        this.parent.position(this.start + this.pointer);
        this.parent.writeFully(src);
        this.pointer += bytes;
    }

    @Override
    public void writeFully(ByteBuffer src, int length) throws IOException {
        this.assertHasWritableBytes(length);
        this.parent.position(this.start + this.pointer);
        this.parent.writeFully(src, length);
        this.pointer += (long)length;
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.assertHasWritableBytes(length);
        this.parent.position(this.start + this.pointer);
        this.parent.write(src, offset, length);
        this.pointer += (long)length;
    }

    @Override
    public void write(byte[] src) throws IOException {
        this.assertHasWritableBytes(src.length);
        this.parent.position(this.start + this.pointer);
        this.parent.write(src);
        this.pointer += (long)src.length;
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.assertHasWritableBytes(8L);
        this.parent.position(this.start + this.pointer);
        this.parent.writeDouble(value);
        this.pointer += 8L;
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.assertHasWritableBytes(4L);
        this.parent.position(this.start + this.pointer);
        this.parent.writeFloat(value);
        this.pointer += 4L;
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.assertHasWritableBytes(4L);
        this.parent.position(this.start + this.pointer);
        this.parent.writeInt(value);
        this.pointer += 4L;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.assertHasWritableBytes(8L);
        this.parent.position(this.start + this.pointer);
        this.parent.writeLong(value);
        this.pointer += 8L;
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.assertHasWritableBytes(2L);
        this.parent.position(this.start + this.pointer);
        this.parent.writeShort(value);
        this.pointer += 2L;
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.assertHasWritableBytes(2L);
        this.parent.position(this.start + this.pointer);
        this.parent.writeChar(value);
        this.pointer += 2L;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.assertHasWritableBytes(len);
        this.parent.position(this.start + this.pointer);
        this.parent.writeBytes(s);
        this.pointer += (long)len;
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.assertHasWritableBytes(len * 2);
        this.parent.position(this.start + this.pointer);
        this.parent.writeChars(s);
        this.pointer += (long)(len * 2);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = UTF8.getModifiedUTF8EncodingByteLength(s);
        this.assertHasWritableBytes(len + 2);
        this.parent.position(this.start + this.pointer);
        this.parent.writeShort(len);
        UTF8.writeUTF(this, s);
        this.pointer += (long)(len + 2);
    }

    @Override
    public byte readByte() throws IOException {
        this.assertHasReadableBytes(1L);
        this.parent.position(this.start + this.pointer);
        byte result = this.parent.readByte();
        ++this.pointer;
        return result;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.assertHasReadableBytes(1L);
        this.parent.position(this.start + this.pointer);
        int result = this.parent.readUnsignedByte();
        ++this.pointer;
        return result;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.assertHasReadableBytes(1L);
        this.parent.position(this.start + this.pointer);
        boolean result = this.parent.readBoolean();
        ++this.pointer;
        return result;
    }

    @Override
    public void readFully(byte[] dst, int offset, int length) throws IOException {
        this.assertHasReadableBytes(length);
        this.parent.position(this.start + this.pointer);
        this.parent.readFully(dst, offset, length);
        this.pointer += (long)length;
    }

    @Override
    public void readFully(byte[] dst) throws IOException {
        this.assertHasReadableBytes(dst.length);
        this.parent.position(this.start + this.pointer);
        this.parent.readFully(dst);
        this.pointer += (long)dst.length;
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        int bytes = (int)Math.min((long)buf.remaining(), this.length - this.pointer);
        this.parent.position(this.start + this.pointer);
        this.parent.readFully(buf, bytes);
        this.pointer += (long)bytes;
    }

    @Override
    public void readFully(ByteBuffer buf, int length) throws IOException {
        this.assertHasReadableBytes(length);
        this.parent.position(this.start + this.pointer);
        this.parent.readFully(buf, length);
        this.pointer += (long)length;
    }

    @Override
    public double readDouble() throws IOException {
        this.assertHasReadableBytes(8L);
        this.parent.position(this.start + this.pointer);
        double result = this.parent.readDouble();
        this.pointer += 8L;
        return result;
    }

    @Override
    public float readFloat() throws IOException {
        this.assertHasReadableBytes(4L);
        this.parent.position(this.start + this.pointer);
        float result = this.parent.readFloat();
        this.pointer += 4L;
        return result;
    }

    @Override
    public int readInt() throws IOException {
        this.assertHasReadableBytes(4L);
        this.parent.position(this.start + this.pointer);
        int result = this.parent.readInt();
        this.pointer += 4L;
        return result;
    }

    @Override
    public long readLong() throws IOException {
        this.assertHasReadableBytes(8L);
        this.parent.position(this.start + this.pointer);
        long result = this.parent.readLong();
        this.pointer += 8L;
        return result;
    }

    @Override
    public short readShort() throws IOException {
        this.assertHasReadableBytes(2L);
        this.parent.position(this.start + this.pointer);
        short result = this.parent.readShort();
        this.pointer += 2L;
        return result;
    }

    @Override
    public String readLine() throws IOException {
        this.assertHasReadableBytes(2L);
        this.parent.position(this.start + this.pointer);
        String result = this.parent.readLine();
        this.pointer += this.parent.position() - this.start - this.pointer;
        return result;
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public char readChar() throws IOException {
        this.assertHasReadableBytes(2L);
        this.parent.position(this.start + this.pointer);
        char result = this.parent.readChar();
        this.pointer += 2L;
        return result;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.assertHasReadableBytes(2L);
        this.parent.position(this.start + this.pointer);
        int result = this.parent.readShort() & 0xFFFF;
        this.pointer += 2L;
        return result;
    }

    void assertHasReadableBytes(long count) {
        if (this.pointer + count > this.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    void assertHasWritableBytes(long count) throws IOException {
        if (this.pointer + count > this.length) {
            this.setLength(this.pointer + count);
        }
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public long position() throws IOException {
        return this.pointer;
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.pointer = newPosition;
    }

    @Override
    public long skipBytes(long bytes) throws IOException {
        this.pointer += bytes;
        return bytes;
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        this.pointer += (long)bytes;
        return bytes;
    }

    public long getStartPositionInSourceBinary() {
        return this.start;
    }

    public String toString() {
        return String.valueOf(this.parent) + "[" + this.start + ".." + (this.start + this.length) + "]";
    }

    static boolean intersects(long start1, long len1, long start2, long len2) {
        if (start1 >= start2 + len2) {
            return false;
        }
        return start1 + len1 > start2;
    }

    public void setPositionInSource(long start, long length) {
        this.start = start;
        this.length = length;
    }
}

