/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.NumberComparator;
import org.simantics.databoard.util.RangeException;

public class Range {
    Limit lower;
    Limit upper;
    static Pattern RANGE_PATTERN = Pattern.compile("(?:([\\(\\[])(-?\\d*(?:\\.\\d*)?(?:[eE]-?\\d+)?)??\\.\\.(-?\\d*(?:\\.\\d*)?(?:[eE]-?\\d+)?)??([\\)\\]]))|(-?+\\d*(?:\\.\\d*)?(?:[eE]-?\\d+)?)|\\(\\)");

    public static Range create(Byte lower, Byte upper, boolean lowerInclusive, boolean upperInclusive) {
        Limit ll = lowerInclusive ? Limit.inclusive(lower) : Limit.exclusive(lower);
        Limit ul = upperInclusive ? Limit.inclusive(upper) : Limit.exclusive(upper);
        return new Range(ll, ul);
    }

    public static Range create(Integer lower, Integer upper, boolean lowerInclusive, boolean upperInclusive) {
        Limit ll = lowerInclusive ? Limit.inclusive(lower) : Limit.exclusive(lower);
        Limit ul = upperInclusive ? Limit.inclusive(upper) : Limit.exclusive(upper);
        return new Range(ll, ul);
    }

    public static Range create(Long lower, Long upper, boolean lowerInclusive, boolean upperInclusive) {
        Limit ll = lowerInclusive ? Limit.inclusive(lower) : Limit.exclusive(lower);
        Limit ul = upperInclusive ? Limit.inclusive(upper) : Limit.exclusive(upper);
        return new Range(ll, ul);
    }

    public static Range create(Float lower, Float upper, boolean lowerInclusive, boolean upperInclusive) {
        Limit ll = lowerInclusive ? Limit.inclusive(lower) : Limit.exclusive(lower);
        Limit ul = upperInclusive ? Limit.inclusive(upper) : Limit.exclusive(upper);
        return new Range(ll, ul);
    }

    public static Range create(Double lower, Double upper, boolean lowerInclusive, boolean upperInclusive) {
        Limit ll = lowerInclusive ? Limit.inclusive(lower) : Limit.exclusive(lower);
        Limit ul = upperInclusive ? Limit.inclusive(upper) : Limit.exclusive(upper);
        return new Range(ll, ul);
    }

    public static Range create(Byte exact) {
        Limit l = Limit.inclusive(exact);
        return new Range(l, l);
    }

    public static Range create(Integer exact) {
        Limit l = Limit.inclusive(exact);
        return new Range(l, l);
    }

    public static Range create(Long exact) {
        Limit l = Limit.inclusive(exact);
        return new Range(l, l);
    }

    public static Range create(Float exact) {
        Limit l = Limit.inclusive(exact);
        return new Range(l, l);
    }

    public static Range create(Double exact) {
        Limit l = Limit.inclusive(exact);
        return new Range(l, l);
    }

    public static Range includeAll() {
        Limit l = Limit.nolimit();
        return new Range(l, l);
    }

    public static Range excludeAll() {
        Limit l = Limit.exclusive(0);
        return new Range(l, l);
    }

    public static Range between(Limit limit1, Limit limit2) {
        Number l = limit1.getValue();
        Number u = limit2.getValue();
        if (l != null && u != null && NumberComparator.INSTANCE.compare(l, u) < 0) {
            return new Range(limit2, limit1);
        }
        return new Range(limit1, limit2);
    }

    public Range(Limit lower, Limit upper) {
        this.lower = lower;
        this.upper = upper;
        Number l = lower.getValue();
        Number u = upper.getValue();
        if (l != null && u != null && NumberComparator.INSTANCE.compare(l, u) < 0) {
            throw new IllegalArgumentException("Lower limit must be less-or-equal to upper limit");
        }
        if (l != null && u != null && l.equals(u) && (lower.isExclusive() || upper.isExclusive())) {
            this.lower = this.upper = Limit.exclusive(0);
        }
    }

    public Limit getLower() {
        return this.lower;
    }

    public Limit getUpper() {
        return this.upper;
    }

    public String toString() {
        if (this.lower instanceof Limit.Nolimit && this.upper instanceof Limit.Nolimit) {
            return "[..]";
        }
        StringBuilder sb = new StringBuilder();
        Number l = this.lower.getValue();
        Number u = this.upper.getValue();
        if (l != null && u != null && l.equals(u)) {
            if (this.lower.isExclusive() || this.upper.isExclusive()) {
                return "()";
            }
            return l.toString();
        }
        sb.append(!this.lower.isInclusive() ? Character.valueOf('(') : "[");
        if (!(this.lower instanceof Limit.Nolimit)) {
            sb.append(l);
        }
        sb.append("..");
        if (!(this.upper instanceof Limit.Nolimit)) {
            sb.append(u);
        }
        sb.append(!this.upper.isInclusive() ? Character.valueOf(')') : "]");
        return sb.toString();
    }

    public static Range valueOfUnchecked(String txt) {
        try {
            return Range.valueOf(txt);
        }
        catch (RangeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Range valueOf(String txt) throws RangeException {
        Matcher m = RANGE_PATTERN.matcher(txt);
        if (!m.matches()) {
            throw new RangeException("Illegal range '" + txt + "'");
        }
        if (m.group(1) != null || m.group(2) != null || m.group(3) != null || m.group(4) != null) {
            Limit l2;
            Double d;
            Long l;
            Limit l1;
            if (m.group(2) == null && m.group(3) == null) {
                return new Range(Limit.nolimit(), Limit.nolimit());
            }
            if (m.group(2) == null) {
                l1 = Limit.nolimit();
            } else {
                try {
                    l = Long.parseLong(m.group(2));
                    l1 = m.group(1).equals("[") ? Limit.inclusive(l) : Limit.exclusive(l);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        d = Double.parseDouble(m.group(2));
                        l1 = m.group(1).equals("[") ? Limit.inclusive(d) : Limit.exclusive(d);
                    }
                    catch (NumberFormatException e) {
                        throw new RangeException(e);
                    }
                }
            }
            if (m.group(3) == null) {
                l2 = Limit.nolimit();
            } else {
                try {
                    l = Long.parseLong(m.group(3));
                    l2 = m.group(4).equals("]") ? Limit.inclusive(l) : Limit.exclusive(l);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        d = Double.parseDouble(m.group(3));
                        l2 = m.group(4).equals("]") ? Limit.inclusive(d) : Limit.exclusive(d);
                    }
                    catch (NumberFormatException e) {
                        throw new RangeException(e);
                    }
                }
            }
            return new Range(l1, l2);
        }
        if (m.group(5) != null) {
            try {
                Long l = Long.parseLong(m.group(5));
                Limit l1 = Limit.inclusive(l);
                return new Range(l1, l1);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double d = Double.parseDouble(m.group(5));
                    Limit l1 = Limit.inclusive(d);
                    return new Range(l1, l1);
                }
                catch (NumberFormatException e) {
                    throw new RangeException(e);
                }
            }
        }
        Range result = new Range(Limit.exclusive(0), Limit.exclusive(0));
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return (other.upper == null ? this.upper == null : other.upper.equals(this.upper)) && (other.lower == null ? this.lower == null : other.lower.equals(this.lower));
    }

    public int hashCode() {
        return Objects.hashCode(this.upper) * 13 + Objects.hashCode(this.lower);
    }

    public boolean contains(Number value) {
        int compare;
        if (!(this.lower instanceof Limit.Nolimit)) {
            compare = NumberComparator.INSTANCE.compare(this.lower.getValue(), value);
            if (compare == 0 && this.lower.isExclusive()) {
                return false;
            }
            if (compare < 0) {
                return false;
            }
        }
        if (!(this.upper instanceof Limit.Nolimit)) {
            compare = NumberComparator.INSTANCE.compare(this.upper.getValue(), value);
            if (compare == 0 && this.upper.isExclusive()) {
                return false;
            }
            if (compare > 0) {
                return false;
            }
        }
        return true;
    }
}

