/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.binary.Endian;
import org.simantics.databoard.util.binary.UTF8;

public class UTF8StringSerializer
extends Serializer.NonRecursiveSerializer {
    StringBinding binding;

    public UTF8StringSerializer(StringBinding binding) {
        this.binding = binding;
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        try {
            int length = Endian.readDynamicUInt32(in);
            this.assertRemainingBytes(in, length);
            String str = UTF8.readUTF(in, length);
            return this.binding.create(str);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            int length = Endian.readDynamicUInt32(in);
            this.assertRemainingBytes(in, length);
            String str = UTF8.readUTF(in, length);
            this.binding.setValue(obj, str);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        int length = Endian.readDynamicUInt32(in);
        in.skipBytes(length);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        try {
            byte[] bytes = this.binding.getValue(obj).getBytes(UTF8.CHARSET);
            Endian.writeDynamicUInt32(out, bytes.length);
            out.write(bytes);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return null;
    }

    @Override
    public int getSize(Object obj) throws IOException {
        try {
            String string = this.binding.getValue(obj);
            int stringByteLength = UTF8.getUTF8EncodingByteLength(string);
            int lengthLength = Endian.getDynamicUInt32Length(stringByteLength);
            return lengthLength + stringByteLength;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return 1;
    }
}

