/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.binary.Endian;

public class IntArraySerializer
extends Serializer.NonRecursiveSerializer {
    Range length;
    Integer fixedLength;
    Integer fixedSize;

    public IntArraySerializer(ArrayBinding binding) {
        ArrayType arrayType = binding.type();
        this.length = arrayType.getLength();
        if (this.length != null && this.length.getLower().equals(this.length.getUpper()) && this.length.getLower().getValue() != null) {
            this.fixedLength = this.length.getLower().getValue().intValue();
            this.fixedSize = this.fixedLength * 4;
        }
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength : Endian.readInt(data);
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        if (data.length < length * 4 + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        int[] array = new int[length];
        int i = 0;
        int offset = 4;
        while (i < array.length) {
            array[i] = Endian.readInt(data, offset);
            ++i;
            offset += 4;
        }
        return array;
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        int[] array;
        int length = this.fixedLength != null ? this.fixedLength : Endian.readInt(data);
        if (length != (array = (int[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        if (data.length < length * 4 + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        int i = 0;
        int offset = 4;
        while (i < array.length) {
            array[i] = Endian.readInt(data, offset);
            ++i;
            offset += 4;
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        this.assertRemainingBytes(in, (long)length * 4L);
        int[] array = new int[length];
        int i = 0;
        while (i < array.length) {
            array[i] = in.readInt();
            ++i;
        }
        return array;
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object obj) throws IOException {
        int[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (int[])obj).length) {
            array = new int[length];
        }
        this.assertRemainingBytes(in, (long)length * 4L);
        int i = 0;
        while (i < array.length) {
            array[i] = in.readInt();
            ++i;
        }
        return array;
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        float[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (float[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        this.assertRemainingBytes(in, (long)length * 4L);
        int i = 0;
        while (i < array.length) {
            array[i] = in.readFloat();
            ++i;
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        int length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        this.skipBytes(in, length, (long)length * 4L);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        int[] array = (int[])obj;
        if (this.fixedSize == null) {
            out.writeInt(array.length);
        }
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int f = nArray[n2];
            out.writeInt(f);
            ++n2;
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj) {
        if (this.fixedSize != null) {
            return this.fixedSize;
        }
        int[] array = (int[])obj;
        return 4 + 4 * array.length;
    }

    @Override
    public int getMinSize() {
        return this.fixedSize != null ? this.fixedSize : 4;
    }
}

