/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.ClassBinding;
import org.simantics.databoard.binding.util.IsReferableQuery;
import org.simantics.databoard.binding.util.Result;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.impl.BooleanSerializer;
import org.simantics.databoard.serialization.impl.ByteSerializer;
import org.simantics.databoard.serialization.impl.DoubleSerializer;
import org.simantics.databoard.serialization.impl.FloatSerializer;
import org.simantics.databoard.serialization.impl.IntSerializer;
import org.simantics.databoard.serialization.impl.LongSerializer;

public class GenericRecordSerializer
extends Serializer.CompositeSerializer {
    RecordBinding binding;
    public Serializer[] componentSerializers;
    Integer fixedSize;
    int minSize;
    boolean createPartial;
    public int[] fieldType;

    public GenericRecordSerializer(RecordBinding binding, Serializer[] componentSerializers) {
        super(IsReferableQuery.isReferable(binding.type()) != Result.No);
        this.binding = binding;
        this.componentSerializers = componentSerializers;
    }

    @Override
    public void finalizeConstruction() {
        this.fixedSize = null;
        boolean bl = this.createPartial = !this.binding.isImmutable();
        if (this.binding instanceof ClassBinding) {
            ClassBinding cb = (ClassBinding)this.binding;
            this.createPartial &= cb.ci.partialConstructionPossible;
        }
        this.fieldType = new int[this.componentSerializers.length];
        int i = 0;
        while (i < this.componentSerializers.length) {
            Serializer cs = this.componentSerializers[i];
            this.minSize += cs.getMinSize();
            Integer componentFixedSize = cs.getConstantSize();
            if (componentFixedSize == null) {
                this.fixedSize = null;
                break;
            }
            this.fixedSize = this.fixedSize == null ? componentFixedSize : this.fixedSize + componentFixedSize;
            int type = 0;
            if (cs instanceof BooleanSerializer) {
                type = 1;
            } else if (cs instanceof ByteSerializer) {
                type = 2;
            } else if (cs instanceof IntSerializer) {
                type = 3;
            } else if (cs instanceof LongSerializer) {
                type = 4;
            } else if (cs instanceof FloatSerializer) {
                type = 5;
            } else if (cs instanceof DoubleSerializer) {
                type = 6;
            }
            this.fieldType[i] = type;
            ++i;
        }
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            if (this.createPartial) {
                Object obj = this.binding.createPartial();
                this.deserializeTo(in, identities, obj);
                return obj;
            }
            Object[] temp = new Object[this.componentSerializers.length];
            int i = 0;
            while (i < this.componentSerializers.length) {
                temp[i] = this.componentSerializers[i].deserialize(in, identities);
                ++i;
            }
            return this.binding.create(temp);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            int i = 0;
            while (i < this.componentSerializers.length) {
                Serializer cs = this.componentSerializers[i];
                int type = this.fieldType[i];
                switch (type) {
                    case 0: {
                        Object component;
                        Binding cb = this.binding.componentBindings[i];
                        boolean csImmutable = cb.isImmutable();
                        if (csImmutable) {
                            component = cs.deserialize(in, identities);
                            this.binding.setComponent(obj, i, component);
                            break;
                        }
                        component = this.binding.getComponent(obj, i);
                        if (component == null) {
                            component = cs.deserialize(in, identities);
                            this.binding.setComponent(obj, i, component);
                            break;
                        }
                        Object newComponent = cs.deserializeToTry(in, identities, component);
                        if (newComponent == component) break;
                        this.binding.setComponent(obj, i, newComponent);
                        break;
                    }
                    case 1: {
                        this.binding.setBoolean(obj, i, ((BooleanSerializer)cs).getBoolean(in));
                        break;
                    }
                    case 2: {
                        this.binding.setByte(obj, i, ((ByteSerializer)cs).getByte(in));
                        break;
                    }
                    case 3: {
                        this.binding.setInt(obj, i, ((IntSerializer)cs).getInt(in));
                        break;
                    }
                    case 4: {
                        this.binding.setLong(obj, i, ((LongSerializer)cs).getLong(in));
                        break;
                    }
                    case 5: {
                        this.binding.setFloat(obj, i, ((FloatSerializer)cs).getFloat(in));
                        break;
                    }
                    case 6: {
                        this.binding.setDouble(obj, i, ((DoubleSerializer)cs).getDouble(in));
                    }
                }
                ++i;
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException, SerializationException {
        if (this.fixedSize != null) {
            in.skipBytes(this.fixedSize);
        } else {
            int i = 0;
            while (i < this.componentSerializers.length) {
                this.componentSerializers[i].skip(in, identities);
                ++i;
            }
        }
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
        try {
            int i = 0;
            while (i < this.componentSerializers.length) {
                int type = this.fieldType[i];
                Serializer cs = this.componentSerializers[i];
                switch (type) {
                    case 0: {
                        cs.serialize(out, identities, this.binding.getComponent(obj, i));
                        break;
                    }
                    case 1: {
                        ((BooleanSerializer)cs).putBoolean(out, this.binding.getBoolean(obj, i));
                        break;
                    }
                    case 2: {
                        ((ByteSerializer)cs).putByte(out, this.binding.getByte(obj, i));
                        break;
                    }
                    case 3: {
                        ((IntSerializer)cs).putInt(out, this.binding.getInt(obj, i));
                        break;
                    }
                    case 4: {
                        ((LongSerializer)cs).putLong(out, this.binding.getLong(obj, i));
                        break;
                    }
                    case 5: {
                        ((FloatSerializer)cs).putFloat(out, this.binding.getFloat(obj, i));
                        break;
                    }
                    case 6: {
                        ((DoubleSerializer)cs).putDouble(out, this.binding.getDouble(obj, i));
                    }
                }
                ++i;
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        try {
            if (this.fixedSize != null) {
                return this.fixedSize;
            }
            int result = 0;
            int i = 0;
            while (i < this.componentSerializers.length) {
                result += this.componentSerializers[i].getSize(this.binding.getComponent(obj, i), identities);
                ++i;
            }
            return result;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }
}

