/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.binary.Endian;

public class ByteArraySerializer
extends Serializer.NonRecursiveSerializer {
    Range length;
    Integer fixedLength;
    Integer fixedSize;

    public ByteArraySerializer(ArrayBinding binding) {
        ArrayType arrayType = binding.type();
        this.length = arrayType.getLength();
        if (this.length != null && this.length.getLower().equals(this.length.getUpper()) && this.length.getLower().getValue() != null) {
            this.fixedLength = this.length.getLower().getValue().intValue();
            this.fixedSize = this.fixedLength * 1;
        }
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength : Endian.readInt(data);
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        if (data.length < length + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        return Arrays.copyOfRange(data, 4, length + 4);
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        byte[] array;
        int length = this.fixedLength != null ? this.fixedLength : Endian.readInt(data);
        if (length != (array = (byte[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        if (data.length < length + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        System.arraycopy(data, 4, array, 0, length + 4);
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        this.assertRemainingBytes(in, length);
        byte[] array = new byte[length];
        in.readFully(array);
        return array;
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
            byte[] array = (byte[])obj;
            if (length != array.length) {
                throw new BindingException("primitive array is size immutable");
            }
            this.assertRemainingBytes(in, length);
            in.readFully(array);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object obj) throws IOException {
        byte[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (byte[])obj).length) {
            obj = new byte[length];
        }
        this.assertRemainingBytes(in, length);
        in.readFully(array);
        return array;
    }

    @Override
    public void skip(DataInput in) throws IOException {
        int length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        this.skipBytes(in, length, length);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        byte[] array = (byte[])obj;
        if (this.fixedSize == null) {
            out.writeInt(array.length);
        }
        out.write(array);
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj) {
        if (this.fixedSize != null) {
            return this.fixedSize;
        }
        byte[] array = (byte[])obj;
        return 4 + array.length;
    }

    @Override
    public int getMinSize() {
        return this.fixedSize != null ? this.fixedSize : 4;
    }
}

