/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;

public class BooleanSerializer
extends Serializer.NonRecursiveSerializer {
    BooleanBinding binding;

    public BooleanSerializer(BooleanBinding binding) {
        this.binding = binding;
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        try {
            boolean value = data[0] != 0;
            return this.binding.create(value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        try {
            boolean value = data[0] != 0;
            this.binding.setValue(obj, value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        try {
            boolean value = in.readByte() != 0;
            return this.binding.create(value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            boolean newValue = in.readByte() != 0;
            this.binding.setValue(obj, newValue);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        in.skipBytes(1);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        try {
            boolean value = this.binding.getValue_(obj);
            out.write((byte)(value ? 1 : 0));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return 1;
    }

    @Override
    public int getSize(Object obj) {
        return 1;
    }

    @Override
    public int getMinSize() {
        return 1;
    }

    public boolean getBoolean(DataInput in) throws IOException {
        return in.readByte() != 0;
    }

    public void putBoolean(DataOutput out, boolean x) throws IOException {
        out.writeBoolean(x);
    }
}

