/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.Sized;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.Endian;
import org.simantics.databoard.util.binary.UTF8;

public class AppendableModifiedUTF8StringSerializer
extends Serializer.NonRecursiveSerializer {
    StringBinding binding;

    public AppendableModifiedUTF8StringSerializer(StringBinding binding) {
        this.binding = binding;
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        try {
            return this.binding.create(UTF8.readModifiedUTF(data, 4, data.length));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        try {
            this.binding.setValue(obj, UTF8.readModifiedUTF(data, 4, data.length));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        try {
            int len = in.readInt();
            this.assertRemainingBytes(in, len);
            return this.binding.create(UTF8.readModifiedUTF(in, len));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            int len = in.readInt();
            this.assertRemainingBytes(in, len);
            this.binding.setValue(obj, UTF8.readModifiedUTF(in, len));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in) throws IOException, SerializationException {
        int len = in.readInt();
        this.assertRemainingBytes(in, len);
        in.skipBytes(len);
    }

    @Override
    public void transfer(InputStream in, BinaryWriteable w) throws IOException {
        int length = Endian.readInt(in);
        if (in instanceof Sized) {
            length = ((Sized)((Object)in)).getAmountOfBytes() - 4;
        }
        w.writeInt(length);
        int i = 0;
        while (i < length) {
            w.write(in.read());
            ++i;
        }
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        try {
            String str = this.binding.getValue(obj);
            out.writeInt(UTF8.getModifiedUTF8EncodingByteLength(str));
            UTF8.writeModifiedUTF(out, str);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return null;
    }

    @Override
    public int getSize(Object obj) throws IOException {
        try {
            return 4 + UTF8.getModifiedUTF8EncodingByteLength(this.binding.getValue(obj));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return 4;
    }
}

