/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SerializerScheme;

public abstract class SerializerFactory
implements SerializerScheme {
    protected Map<Binding, SerializerConstructionException> failures = new HashMap<Binding, SerializerConstructionException>();
    Map<Binding, Serializer> repository;
    Map<Binding, Serializer> inprogress = new HashMap<Binding, Serializer>();

    public SerializerFactory() {
        this.repository = new HashMap<Binding, Serializer>();
    }

    public SerializerFactory(Map<Binding, Serializer> repository) {
        this.repository = repository;
    }

    public Map<Binding, Serializer> getRepository() {
        return this.repository;
    }

    protected abstract Serializer doConstruct(Binding var1) throws SerializerConstructionException;

    public Serializer construct(Binding request) throws SerializerConstructionException {
        Serializer ser = request.cachedSerializer();
        if (ser != null) {
            return ser;
        }
        ser = this.repository.get(request);
        if (ser != null) {
            return ser;
        }
        ser = this.inprogress.get(request);
        if (ser != null) {
            return ser;
        }
        SerializerConstructionException e = this.failures.get(request);
        if (e != null) {
            throw e;
        }
        try {
            Serializer binding = this.doConstruct(request);
            this.repository.put(request, binding);
            request.cacheSerializer(binding);
            return binding;
        }
        catch (SerializerConstructionException e2) {
            this.inprogress.remove(request);
            this.failures.put(request, e2);
            throw e2;
        }
    }

    @Override
    public Serializer getSerializer(Binding binding) throws SerializerConstructionException {
        return this.construct(binding);
    }

    @Override
    public Serializer getSerializerUnchecked(Binding binding) throws RuntimeSerializerConstructionException {
        try {
            return this.construct(binding);
        }
        catch (SerializerConstructionException e) {
            throw new RuntimeSerializerConstructionException(e);
        }
    }
}

