/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser.unparsing;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.parser.ast.type.AstArrayType;
import org.simantics.databoard.parser.ast.type.AstComponent;
import org.simantics.databoard.parser.ast.type.AstRecordType;
import org.simantics.databoard.parser.ast.type.AstTupleType;
import org.simantics.databoard.parser.ast.type.AstType;
import org.simantics.databoard.parser.ast.type.AstTypeDefinition;
import org.simantics.databoard.parser.ast.type.AstTypeReference;
import org.simantics.databoard.parser.ast.type.AstUnionType;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;

public class DataTypeToAst
implements Datatype.Visitor<AstType> {
    List<AstTypeDefinition> typeDefinitions = new ArrayList<AstTypeDefinition>();
    DataTypeRepository repo = new DataTypeRepository();
    THashSet<Datatype> underConstruction = new THashSet();
    int id = 0;

    public DataTypeToAst(DataTypeRepository repo) {
        this.repo = repo;
    }

    private String freshTypeName() {
        return "Temp" + ++this.id;
    }

    public AstType addDefinition(String name, Datatype type) {
        this.repo.add(name, type);
        AstType ast = type.accept(this);
        this.typeDefinitions.add(new AstTypeDefinition(name, type.accept(this)));
        return ast;
    }

    public AstType visit(Datatype type) {
        if (this.repo.contains(type)) {
            return new AstTypeReference(this.repo.get(type));
        }
        if (this.underConstruction.contains((Object)type)) {
            String name = this.repo.get(type);
            if (name == null) {
                name = this.freshTypeName();
                this.repo.add(name, type);
            }
            this.underConstruction.remove((Object)type);
            return new AstTypeReference(name);
        }
        this.underConstruction.add((Object)type);
        AstType ast = type.accept(this);
        if (!this.underConstruction.remove((Object)type)) {
            String name = this.repo.get(type);
            this.typeDefinitions.add(new AstTypeDefinition(name, ast));
            return new AstTypeReference(name);
        }
        return ast;
    }

    @Override
    public AstType visit(ArrayType b) {
        return new AstArrayType(this.visit(b.componentType), b.getLength() == null ? null : b.getLength().getLower().smallestIncludedInteger(), b.getLength() == null ? null : b.getLength().getUpper().greatestIncludedInteger());
    }

    @Override
    public AstType visit(BooleanType b) {
        return new AstTypeReference("Boolean");
    }

    @Override
    public AstType visit(DoubleType b) {
        AstTypeReference ref = new AstTypeReference("Double");
        if (b.metadata.containsKey("range")) {
            ref.addAttribute("range", (String)b.metadata.get("range"));
        }
        if (b.metadata.containsKey("unit")) {
            ref.addAttribute("unit", (String)b.metadata.get("unit"));
        }
        return ref;
    }

    @Override
    public AstType visit(FloatType b) {
        AstTypeReference ref = new AstTypeReference("Float");
        if (b.metadata.containsKey("range")) {
            ref.addAttribute("range", (String)b.metadata.get("range"));
        }
        if (b.metadata.containsKey("unit")) {
            ref.addAttribute("unit", (String)b.metadata.get("unit"));
        }
        return ref;
    }

    @Override
    public AstType visit(IntegerType b) {
        AstTypeReference ref = new AstTypeReference("Integer");
        if (b.metadata.containsKey("range")) {
            ref.addAttribute("range", (String)b.metadata.get("range"));
        }
        if (b.metadata.containsKey("unit")) {
            ref.addAttribute("unit", (String)b.metadata.get("unit"));
        }
        return ref;
    }

    @Override
    public AstType visit(ByteType b) {
        return new AstTypeReference("Byte");
    }

    @Override
    public AstType visit(LongType b) {
        AstTypeReference ref = new AstTypeReference("Long");
        if (b.metadata.containsKey("range")) {
            ref.addAttribute("range", (String)b.metadata.get("range"));
        }
        if (b.metadata.containsKey("unit")) {
            ref.addAttribute("unit", (String)b.metadata.get("unit"));
        }
        return ref;
    }

    @Override
    public AstType visit(OptionalType b) {
        return new AstTypeReference("Optional", this.visit(b.getComponentType()));
    }

    @Override
    public AstType visit(RecordType b) {
        if (b.isTupleType()) {
            AstTupleType tuple = new AstTupleType(new ArrayList<AstType>(b.getComponentCount()));
            Component[] componentArray = b.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                tuple.addComponent(this.visit(component.type));
                ++n2;
            }
            return tuple;
        }
        AstRecordType record = new AstRecordType(b.isReferable(), new ArrayList<AstComponent>(b.getComponentCount()));
        Component[] componentArray = b.getComponents();
        int n = componentArray.length;
        int n3 = 0;
        while (n3 < n) {
            Component component = componentArray[n3];
            record.addComponent(component.name, this.visit(component.type));
            ++n3;
        }
        return record;
    }

    @Override
    public AstType visit(StringType b) {
        AstTypeReference ref = new AstTypeReference("String");
        if (b.metadata.containsKey("mimeType")) {
            ref.addAttribute("mimeType", (String)b.metadata.get("mimeType"));
        }
        if (b.metadata.containsKey("length")) {
            ref.addAttribute("length", (String)b.metadata.get("length"));
        }
        if (b.metadata.containsKey("pattern")) {
            ref.addAttribute("pattern", (String)b.metadata.get("pattern"));
        }
        return ref;
    }

    @Override
    public AstType visit(UnionType b) {
        AstUnionType union = new AstUnionType(new ArrayList<AstComponent>(b.components.length));
        Component[] componentArray = b.components;
        int n = b.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            union.addComponent(component.name, this.visit(component.type));
            ++n2;
        }
        return union;
    }

    @Override
    public AstType visit(VariantType b) {
        AstTypeReference ref = new AstTypeReference("Variant");
        return ref;
    }

    public List<AstTypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @Override
    public AstType visit(MapType b) {
        AstTypeReference ref = new AstTypeReference("Map", this.visit(b.keyType), this.visit(b.valueType));
        return ref;
    }
}

