/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.binding.impl.BooleanBindingDefault;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.util.IdentityPair;

public final class BooleanArrayBinding
extends ArrayBinding {
    public static BooleanArrayBinding createFrom(ArrayType type) {
        return new BooleanArrayBinding(type, new BooleanBindingDefault((BooleanType)type.componentType));
    }

    public BooleanArrayBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
    }

    @Override
    public Object create() {
        return new boolean[0];
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        boolean[] array = new boolean[length];
        int i = 0;
        while (i < length) {
            array[i] = (Boolean)values.next();
            ++i;
        }
        return array;
    }

    @Override
    public Object create(Object[] values) {
        boolean[] result = new boolean[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = (Boolean)values[i];
            ++i;
        }
        return result;
    }

    public Object create(boolean[] array) {
        return array;
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        BooleanBinding scb = (BooleanBinding)sb.getComponentBinding();
        boolean[] d = (boolean[])dst;
        if (d.length != sb.size(src)) {
            throw new BindingException("boolean[] is length immutable");
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        BooleanBinding scb = (BooleanBinding)sb.getComponentBinding();
        boolean[] d = (boolean[])dst;
        int srcSize = sb.size(src);
        if (d.length != srcSize) {
            d = new boolean[srcSize];
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
        return d;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", boolean[] expected");
        }
        return ((boolean[])array)[index];
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        boolean[] a = (boolean[])array;
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        boolean[] a = (boolean[])array;
        a[index] = (Boolean)value;
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", boolean[] expected");
        }
        return ((boolean[])array).length;
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof boolean[];
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public boolean[] getArray(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", boolean[] expected");
        }
        return (boolean[])array;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        boolean[] a1 = (boolean[])o1;
        int l1 = a1.length;
        boolean[] a2 = (boolean[])o2;
        int l2 = a2.length;
        int dif = l1 - l2;
        if (dif != 0) {
            return dif;
        }
        int i = 0;
        while (i < l1) {
            boolean v2 = a2[i];
            boolean v1 = a1[i];
            int n = v2 == v1 ? 0 : (dif = v1 ? 1 : -1);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException("boolean[] is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

