/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.charset.Charset;

public class UTF8 {
    public static final Charset CHARSET = Charset.forName("utf-8");

    public static int getUTF8EncodingByteLength(String string) {
        int result = 0;
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            result = c >= '\u0000' && c <= '\u007f' ? ++result : (c >= '\u0080' && c <= '\u07ff' ? (result += 2) : (c >= '\ud800' && c <= '\udfff' ? ++result : (c >= '\u0800' && c <= '\uffff' ? (result += 3) : (c >= '\u10000' && c <= '\u10ffff' ? (result += 4) : (c >= '\u110000' && c <= '\u1fffff' ? (result += 4) : (result += 5))))));
            ++i;
        }
        return result;
    }

    public static int getModifiedUTF8EncodingByteLength(String str) {
        int strlen = str.length();
        int utflen = 0;
        char c = '\u0000';
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen;
    }

    public static void writeModifiedUTF(DataOutput out, String str) throws IOException {
        int strlen = str.length();
        char c = '\u0000';
        int i = 0;
        i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            if (c < '\u0001' || c > '\u007f') break;
            out.write(c);
            ++i;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    public static String readModifiedUTF(DataInput in, int utflen) throws IOException, UTFDataFormatException {
        int c;
        if (utflen == 0) {
            return "";
        }
        byte[] bytearr = null;
        char[] chararr = null;
        bytearr = new byte[utflen];
        chararr = new char[utflen];
        int count = 0;
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }

    public static String readModifiedUTF(byte[] bytearr, int fromIndex, int toIndex) throws UTFDataFormatException {
        int c;
        int utflen = toIndex - fromIndex;
        if (utflen == 0) {
            return "";
        }
        char[] chararr = new char[utflen];
        int count = fromIndex;
        int chararr_count = 0;
        while (count < toIndex) {
            c = bytearr[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        while (count < toIndex) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > toIndex) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > toIndex) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }

    public static void writeUTF(DataOutput out, String str) throws IOException {
        byte[] bytes = str.getBytes(CHARSET);
        out.write(bytes);
    }

    public static String readUTF(DataInput in, int len) throws IOException {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        return new String(bytes, CHARSET);
    }
}

