/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.BinaryReadable;

public class InputStreamReadable
implements BinaryReadable {
    InputStream is;
    long limit;
    long position;

    public static BinaryReadable readFully(InputStream is) throws IOException {
        byte[] data = StreamUtil.readFully(is);
        return new BinaryMemory(data);
    }

    public InputStreamReadable(InputStream is, long limit) {
        this.is = is;
        this.limit = limit;
    }

    int _get() throws IOException {
        int value = this.is.read();
        if (value == -1) {
            throw new EOFException();
        }
        ++this.position;
        return value & 0xFF;
    }

    int _read() throws IOException {
        int value = this.is.read();
        if (value == -1) {
            return -1;
        }
        ++this.position;
        return value & 0xFF;
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        while (!eol) {
            c = this._read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this._get();
    }

    @Override
    public char readChar() throws IOException {
        return (char)(this._get() << 8 | this._get());
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this._get() & 0xFF;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this._get() != 0;
    }

    @Override
    public void readFully(byte[] dst, int offset, int length) throws IOException {
        while (length > 0) {
            int bytesRead = this.is.read(dst, offset, length);
            if (bytesRead == -1) {
                throw new EOFException();
            }
            this.position += (long)bytesRead;
            offset += bytesRead;
            length -= bytesRead;
        }
    }

    @Override
    public void readFully(byte[] dst) throws IOException {
        this.readFully(dst, 0, dst.length);
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            buf.put((byte)this._get());
        }
    }

    @Override
    public void readFully(ByteBuffer buf, int length) throws IOException {
        if (length < 256) {
            int i = 0;
            while (i < length) {
                buf.put((byte)this._get());
                ++i;
            }
        } else {
            byte[] b = new byte[length];
            this.readFully(b, 0, length);
            buf.put(b);
        }
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readInt() throws IOException {
        return this._get() << 24 | this._get() << 16 | this._get() << 8 | this._get();
    }

    @Override
    public long readLong() throws IOException {
        return (long)this._get() << 56 | (long)this._get() << 48 | (long)this._get() << 40 | (long)this._get() << 32 | (long)this._get() << 24 | (long)this._get() << 16 | (long)this._get() << 8 | (long)this._get();
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this._get() << 8 | this._get());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this._get() << 8 | this._get();
    }

    @Override
    public long length() {
        return this.limit;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skipBytes(long bytes) throws IOException {
        return this.is.skip(bytes);
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        long b = this.is.skip(bytes);
        if (b > Integer.MAX_VALUE) {
            throw new IOException("is.skip(" + bytes + ") returned " + b + " > Integer.MAX_VALUE");
        }
        return (int)b;
    }
}

