/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class DeferredBinaryFile
implements RandomAccessBinary {
    FileSupplier fileSupplier;
    File file;
    int threshold;
    int fileBufferSize;
    BinaryMemory memory;
    RandomAccessBinary backend;

    public DeferredBinaryFile(File file, int threshold, int fileBufferSize) throws IOException {
        this.memory = new BinaryMemory(threshold + 10000);
        this.backend = this.memory;
        this.threshold = threshold;
        this.fileSupplier = () -> file;
        this.file = file;
        this.fileBufferSize = fileBufferSize;
    }

    public DeferredBinaryFile(FileSupplier fileSupplier, int threshold, int fileBufferSize) {
        this.memory = new BinaryMemory(threshold + 10000);
        this.backend = this.memory;
        this.threshold = threshold;
        this.fileSupplier = fileSupplier;
        this.fileBufferSize = fileBufferSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.backend == null) {
            return;
        }
        this.backend.close();
        this.backend = null;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.backend != null;
    }

    @Override
    public byte readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public char readChar() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] dst, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(ByteBuffer buf, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readInt() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        return this.backend.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.backend.position(newPosition);
    }

    @Override
    public void flush() throws IOException {
        this.backend.flush();
    }

    @Override
    public void reset() throws IOException {
        this.backend.reset();
    }

    @Override
    public long skipBytes(long bytes) throws IOException {
        return this.backend.skipBytes(bytes);
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        return this.backend.skipBytes(bytes);
    }

    @Override
    public void write(int b) throws IOException {
        this.backend.write(b);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.backend.writeByte(b);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.backend.writeBoolean(v);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeFully(ByteBuffer src) throws IOException {
        this.backend.writeFully(src);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeFully(ByteBuffer src, int length) throws IOException {
        this.backend.writeFully(src, length);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.backend.write(src, offset, length);
    }

    @Override
    public void write(byte[] src) throws IOException {
        this.backend.write(src);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.backend.writeDouble(value);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.backend.writeFloat(value);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.backend.writeInt(value);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.backend.writeLong(value);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.backend.writeShort(value);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.backend.writeChar(value);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.backend.writeBytes(s);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.backend.writeChars(s);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.backend.writeUTF(s);
        if (this.memory != null) {
            this.threshold();
        }
    }

    @Override
    public void insertBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() throws IOException {
        return this.backend.length();
    }

    @Override
    public void setLength(long newLength) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        try {
            return "DeferredBinaryFile(file=" + this.file.getName() + ", size=" + this.length() + ")";
        }
        catch (IOException iOException) {
            return "DeferredBinaryFile()";
        }
    }

    private void threshold() throws IOException {
        if (this.backend.position() >= (long)this.threshold) {
            this.file = this.fileSupplier.get();
            this.backend = new BinaryFile(this.file, this.fileBufferSize);
            long length = this.memory.position();
            this.memory.position(0L);
            this.memory.toByteBuffer().position(0);
            this.backend.writeFully(this.memory.toByteBuffer(), (int)length);
            this.memory = null;
        }
    }

    public boolean isInMemory() {
        return this.memory != null;
    }

    public RandomAccessBinary getMemory() {
        return this.memory;
    }

    public RandomAccessBinary getBackend() {
        return this.backend;
    }

    public File getFile() {
        return this.file;
    }

    @FunctionalInterface
    public static interface FileSupplier {
        public File get() throws IOException;
    }
}

